
#ifndef _TLK_SCLK_ATP_UTIL_H_
#define _TLK_SCLK_ATP_UTIL_H_


#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  30 October 2008
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version TLK_SCLK_ATP_UTIL.h#1:incl:1
  *  \author Liron Dror
  *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
  *           All Rights reserved
  */
  /************************ Defines *******************************/

#include "DX_VOS_BaseTypes.h"
#include "tlk_sclk_api_config.h"
#include "MW_ATP_defines.h"
#include "tlk_sclk_api_types.h"
	
  /*****************************************************************************
  * Function Name:                                                           
  * 	TLK_SCLK_TST_CheckErrorReturn 		
  * 
  * Inputs:
  * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
  *  char         TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
  *  char 	      TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
  *  char 	      TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
  *
  * Outputs:
  * 	DxError_t - Function error return		    					  		
  *
  * Description:																	
  * this function returns the appropriate printing for a checked function 
  * If the operation had Succeeded of failed	the appropriate printing and return value
  *
  ******************************************************************************/
  DxError_t TLK_SCLK_TST_CheckErrorReturn(DxError_t TST_ErrorRet, 
                                          char 	    TST_FuncName[TST_FUNC_STRING_LEN],
                                          char 	    TST_MasterTestName[TST_FUNC_STRING_LEN]);

  /*****************************************************************************
  * Function Name:                                                           
  *  TLK_SCLK_TST_GetFormattedTime        
  * 
  * Inputs:
  *  TLK_SCLK_TimeFormat_t         TimeFormat - time format 
  *  TLK_SCLK_ServiceClockTime_t   *SysTime_ptr - pointer to system time.
  *  DxUint32_t                    offset - the relevant offset of the service clock
  *
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  * this function returns the system time in the given time format.
  *
  ******************************************************************************/

  DxError_t TLK_SCLK_TST_GetFormattedTime(TLK_SCLK_TimeFormat_t                   TimeFormat,
                                          DxUint32_t                              Offset,
                                          TLK_SCLK_ServiceClockTime_t             *SysTime_ptr);
   

  /*****************************************************************************
  * Function Name:                                                           
  *  TLK_SCLK_TST_InitSST        
  * 
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  * this function initialize the SST.
  *
  ******************************************************************************/
  DxError_t TLK_SCLK_TST_Init(void);

  /*****************************************************************************
  * Function Name:                                                           
  *  TLK_SCLK_TST_TerminateSST        
  * 
  * Outputs:
  *  DxError_t - Function error return                                        
  *
  * Description:                                                                 
  * this function initialize the SST.
  *
  ******************************************************************************/
  DxError_t TLK_SCLK_TST_Terminate(void);

#ifdef __cplusplus
}
#endif

#endif


